; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;

; ---------------------                                                                     [State -1]

; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their command detection.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10
;

;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;


;-| AI |-------------------------------------------------------------
[Command]
name = "CPU1"
command = U,U,U,U,F,F,F,F
time = 1

[Command]
name = "CPU2"
command = U,D,DB,U,F,F,F,F,D
time = 1

[Command]
name = "CPU3"
command = U,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU4"
command = U,D,F,U,F,F,F,F,U,D,B
time = 1

[Command]
name = "CPU5"
command = B,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU6"
command = U,D,F,U,B,F,B,F,U,D,U
time = 1

[Command]
name = "CPU7"
command = F,B,F,U,B,F,B,F,U,D,U
time = 1


[Command]
name = "CPU8"
command = F,B,F,U,B,F,B,F,U,D,U,B
time = 1

[Command]
name = "CPU9"
command = F,B,F,U,B,F,B,F,U,D,U,B,F
time = 1

[Command]
name = "CPU10"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D
time = 1

[Command]
name = "CPU11"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F
time = 1
[Command]
name = "CPU12"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,x
time = 1

[Command]
name = "CPU13"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F,DB
time = 1

[Command]
name = "CPU14"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU15"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU16"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F
time = 1


[Command]
name = "CPU17"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F
time = 1


[Command]
name = "CPU18"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,D
time = 1

[Command]
name = "CPU19"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,D,F
time = 1

[Command]
name = "CPU20"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,D,a
time = 1

[Command]
name = "CPU21"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F,D,b
time = 1
;----------------------------------------------------------------------



;[command]
;name = "leirap"
;command = ~30$B, $F, y
;time = 20

[Command]
name = "Guts Upper"
command = ~F, D, DF, x
time = 15


[Command]
name = "Guts Upper1"
command = ~F, D, DF, y
time = 15



[Command]
name = "chutearyusuke01"
command = ~D, DF, F, a
time = 16

[Command]
name = "chutearyusuke02"
command = ~D, DF, F, b
time = 16

[command]
name = "leirap"
command = x+a
time = 20

[Command]
name = "Empurra"
command = y+b
time = 20


[Command]
name = "hold_x";Required (do not remove)
command = /x
time = 1

[Command]
name = "hold_y";Required (do not remove)
command = /y
time = 1

[command]
name = "empu01"
command = D,F, b
time = 25


[command]
name = "hole1"
command = D,F, a
time = 25


[command]
name = "counter01"
command = D,DB,B, b
time = 20

[command]
name = "counter02"
command = D,DB,B, a
time = 20


[command]
name = "lei2"
command = D,DF,F,y
time = 20

[command]
name = "leiganalto"
command = D,F,x
time = 15

[command]
name = "leiganalto2"
command = D,F,y
time = 15

[Command]
name = "shotnovo"
command = D,D, x;D, DB, x
time = 20

[command]
name = "Shote2"
command = D,D, y;D,DB,B, y
time = 20


[Command]
name = "leigan"
command = D, DF, x
time = 15


[Command]
name = "leiga"
command = D, DF, F, D, DF, F,  x
time = 30

[Command]
name = "leiga01"
command = D, DF, F, D, DF, F,  x
time = 30


[Command]
name = "leigav"
command = D, DF, F, D, DF, F,  y
time = 30

[Command]
name = "TripleKFPalm"
command = ~D, DF, F, D, DF, F, x
time = 20

;[Command]
;name = "charge"
;command = /y

;[Command]
;name = "charge 1"
;command = /b


[Command]
name = "Superpulo"
command = ~D, U
time = 5

[Command]
name = "Superpulo"
command = ~D, UF
time = 5

[Command]
name = "Superpulo"
command = ~D, UB
time = 5


[Command]
name = "SocoChao"
command = y+b
time = 25

[Command]
name = "hold_s"
command = /z
time = 1

[Command]
name = "shotegan"
command = D,DB,D,DB,   y
time = 25

[Command]
name = "especialfinal"
command =  D, DF, F, D, DF, F, y+b
time = 30


[Command]
name = "golpe01"
command = D, DB, B, D, DB, B, y+b
time = 30



;-| Special Motions |------------------------------------------------------


;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]




;=========================================================================

[state -1]
type = changestate
triggerall = random < 100
triggerall = var(59) = 1
triggerall = stateno != 40
triggerall = statetype != a
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numhelper >= 1)
trigger1 = ctrl = 1
trigger2 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger2 = ctrl = 1
value = 40

[state -1]
type = varset
trigger1 = var(59) = 1
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger1 = ctrl = 1
v = 3
value = 1


[State -1, Inteligencia]
type = VarSet
trigger1  = command = "CPU1"
trigger2  = command = "CPU2"
trigger3  = command = "CPU3"
trigger4  = command = "CPU4"
trigger5  = command = "CPU5"
trigger6  = command = "CPU6"
trigger7  = command = "CPU7"
trigger8  = command = "CPU8"
trigger8  = command = "CPU9"
trigger8  = command = "CPU10"
trigger11  = command = "CPU11"
trigger12  = command = "CPU12"
trigger13  = command = "CPU13"
trigger14  = command = "CPU14"
trigger15  = command = "CPU15"
trigger16  = command = "CPU16"
trigger17  = command = "CPU17"
trigger18  = command = "CPU18"
trigger19  = command = "CPU19"
trigger20  = command = "CPU20"
trigger21  = command = "CPU21"
v = 59
value = 1

[state -1]
type = changestate
value = 0
triggerall = var(59) = 1
triggerall = roundstate = 3
trigger1 = statetype != a
trigger1 = ctrl


;------------------COMBOS YUSUKE--------------------------------------------
;ground combo 0--------------------------------------------------
[state -1,1]
type = changestate
value = 200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 150
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 150

[state -1,1]
type = changestate
value = 200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,25]
trigger1 = random < 150
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,25]
trigger2 = random < 150

[state -1,2]
type = changestate
value = 201
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 200
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1]
type = changestate
value = 201
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 200
trigger1 = movecontact
trigger1 = random < 50

[state -1]
type = changestate
value = 202
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 201
trigger1 = movecontact

[state -1]
type = changestate
value = 311
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 202 ||  stateno = 210
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 311
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 202 ||  stateno = 210  
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1200
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210  
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1202
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210  
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1200
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210  
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1202
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210  
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 348
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210  || stateno = 410
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 306
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210 || stateno = 410 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 306
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210  || stateno = 410
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 348
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 202 || stateno = 210 || stateno = 410 
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 340
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 1000
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 1200 || stateno = 311 || stateno = 210  
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 723
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 1000
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 348 ;|| stateno = 610
trigger1 = movecontact
trigger1 = random < 10


[state -1]
type = changestate
value = 701
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 2000
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 1200 || stateno = 1202 = stateno = 311 
trigger1 = movecontact
trigger1 = random < 10


;ground combo 1--------------------------------------------------

;"CPU5"
[state -1,1]
type = changestate
value = 230
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,15]
trigger1 = random < 500
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,15]
trigger2 = random < 500


[state -1,2]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 230
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 211
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 210
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 211
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 60
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
;triggerall = power >= 500
;triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 410
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 40
trigger2 = p2bodydist x = [0,50]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 630
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 600
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 610
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 630
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 640
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 640
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1]
type = changestate
value = 506
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 611 ;|| stateno = 610
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1300
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 150
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 611 ;|| stateno = 610
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1303
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 611 ;|| stateno = 610
trigger1 = movecontact
trigger1 = random < 10


[state -1]
type = changestate
value = 723
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 1000
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 611 ;|| stateno = 610
trigger1 = movecontact
trigger1 = random < 10



;ground combo 3--------------------------------------------------

[state -1,1]
type = changestate
value = 400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,25]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,25]
trigger2 = random < 50

[state -1,2]
type = changestate
value = 430
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 400
trigger1 = movecontact
trigger1 = p2bodydist x < 23
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 60 && enemynear, statetype = l
trigger2 = ctrl

[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 430
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 440
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 430
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 1200
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >3
trigger1 = (Movehit)
trigger1 = stateno = 430 || stateno = 410
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 1202
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 250
triggerall = time >3
trigger1 = (Movehit)
trigger1 = stateno = 430 || stateno = 410
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 306
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >3
trigger1 = (Movehit)
trigger1 = stateno = 430 || stateno = 410
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 348
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 200
triggerall = time >3
;trigger1 = (Movehit)
trigger1 = stateno = 430 || stateno = 410
trigger1 = movecontact
trigger1 = random < 10

;ground combo 4--------------------------------------------------

[state -1]
type = changestate
value = 232
triggerall = var(59) = 1 && roundstate =2
triggerall = time >5
trigger1 = stateno = 231
trigger1 = movecontact
trigger1 = random < 10

[state -1]
type = changestate
value = 340
triggerall = var(59) = 1 && roundstate =2
triggerall = power >= 100
triggerall = time >3
;trigger1 = (Movehit)
trigger1 = stateno = 232 || stateno = 202 || stateno = 202 
trigger1 = movecontact
trigger1 = random < 20

;ground combo 5--------------------------------------------------

[state -1,1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,30]
trigger1 = random < 120
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 120

[state -1,2]
type = changestate
value = 211
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 210
trigger1 = (Movehit)
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 120 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 211
trigger1 = (Movehit)
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 120 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 311
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 410
trigger1 = movecontact
trigger1 = p2bodydist x < 25
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

;ground combo 6--------------------------------------------------

[state -1,1]
type = changestate
value = 100
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,70]
trigger1 = random < 200
trigger2 = stateno = 0
trigger2 = p2bodydist x = [0,110]
trigger2 = random < 200

[state -1,1]
type = changestate
value = 400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,30]
trigger1 = random < 120
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 120

[state -1,1]
type = changestate
value = 430
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,30]
trigger1 = random < 120
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 120

[state -1,2]
type = changestate
value = 400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 100
;trigger1 = (Movehit)
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 30 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 430
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 100
;trigger1 = (Movehit)
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 30 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 1200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
trigger1 = stateno = 430
;trigger1 = (Movehit)
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 30 && enemynear, statetype = l
trigger2 = ctrl





;---------------------------------------------------------------
;"CPU5"
[state -1,1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,35]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,35]
trigger2 = random < 50


[state -1,2]
type = changestate
value = 241
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 240
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 30 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 640
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = time >5
trigger1 = stateno = 241
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 10 && enemynear, statetype = l
trigger2 = ctrl
;---------------------------Golpes AI-------------------------------------

;CPU1
[state -1,1]
type = changestate
value = 1202
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,40]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,60]
trigger2 = random < 10



;CPU2
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 150
trigger1 = ctrl
trigger1 = random <= 10 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 100
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<100,330,330) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<130,330,330)
value = ifelse (p2bodydist x<150,330,330)



;CPU3
[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 350
trigger1 = ctrl
trigger1 = random <= 15 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 20
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<25,305,305) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<30,305,305)
value = ifelse (p2bodydist x<35,305,305)
value = ifelse (p2bodydist x<25,703,703) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<30,703,703)
value = ifelse (p2bodydist x<35,703,703)


;CPU4
[state -1,1]
type = changestate
value = 703
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 350
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,35]
trigger1 = random < 10
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,55]
trigger2 = random < 10



;CPU5
[state -1,1]
type = changestate
value = 348
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,55]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,65]
trigger2 = random < 30


;CPU6
[state -1,1]
type = changestate
value = 311
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,63]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,73]
trigger2 = random < 30

;CPU7
[state -1,1]
type = changestate
value = 1200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,33]
trigger1 = random < 35
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,53]
trigger2 = random < 35


;CPU8
[state -1,1]
type = changestate
value = 1201
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,33]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,53]
trigger2 = random < 30

;CPU9
[state -1,1]
type = changestate
value = 716
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,83]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,113]
trigger2 = random < 30


[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != A
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [150,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 160


[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != A
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [151,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 161

[State -1, AI Guard Push (Standing)]
type = ChangeState
triggerall = Var(59)
;triggerall = AILevel >= 4
triggerall = p2bodydist x =[0,30]
triggerall = StateType != S
triggerall = enemynear, HitDefAttr = SCA,NA,NT,NP,SA,ST,SP
trigger1 = StateNo = [152,153]
trigger1 = Time >= 8
;trigger2 = random < 10
trigger1 = random < 50+50*(BackEdgeDist < 30)
value = 162

;--------------------------------Especiais AI-----------------------------

;CPU13
[state -1,1]
type = changestate
value = 340
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 1000
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,64]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,124]
trigger2 = random < 30

;CPU14
[state -1,1]
type = changestate
value = 347
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 2000
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,74]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,134]
trigger2 = random < 30

;CPU15
[state -1,1]
type = changestate
value = 701
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 2000
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,96]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,166]
trigger2 = random < 30

;CPU16
[state -1,1]
type = changestate
value = 3025
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 2500
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,53]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,103]
trigger2 = random < 30

;CPU17
[state -1,1]
type = changestate
value = 3025
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 2500
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,133]
trigger1 = random < 30
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,233]
trigger2 = random < 30

;------------------------------Movimentos AI-----------------------------------

;CPU18
[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command= "hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)
trigger1 = random <= 5
;trigger1 = p2bodydist x < 150

;CPU19
[State -1, run/dash]
type=changestate
value=ifelse(command="FF",100,105)
trigger1= var(59)<=0
trigger1= command="FF" || command="BB"
trigger1= roundstate=2 && (stateno!=[100,105]) && statetype=S && ctrl
trigger1 = random < 100

;CPU20
[State -1, run/dash]
type=changestate
value=ifelse(command="FF",101,115)
trigger1= var(59)<=0
trigger1= command="FF" || command="BB"
trigger1= roundstate=2 && (stateno!=[101,101]) && statetype=A && ctrl
trigger1 = random < 100
;----------------------------ESPECIAL- ATAQUE-------------------------------

[State -1, Leigan Rapido]
type = ChangeState
value = 3100
triggerall = command = "golpe01"
triggerall = power >= 2500
trigger1 = statetype = S
trigger1 = ctrl

[State -1 Eu Bato Pra Caramba]
type = ChangeState
value = 3025
triggerall = roundstate = 2 && !var(59)
triggerall = power >= 2500 || var(10)
triggerall = command = "especialfinal"
triggerall = statetype != A
trigger1 = ctrl
trigger2 = stateno = 40 || stateno = 101 || stateno = 116
trigger3 = var(7) && (var(8) & 4)
trigger4 = var(10) = 1
trigger4 = (stateno = [200,800)) || (var(7) && stateno = [1000,2000))


[State -1, ]
type = ChangeState
value = 340
trigger1 = command = "leiga"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl


[State -1, Leigan Rapido]
type = ChangeState
value = 723
triggerall = command = "leiga01"
triggerall = power >= 1000
trigger1 = statetype = A
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 347
trigger1 = command = "leigav"
triggerall = power >= 2000
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 701
trigger1 = command = "shotegan"
triggerall = power >= 2000
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 716 
trigger1 = command = "shotnovo"
triggerall = power >= 200
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Leigan Rapido]
type = ChangeState
value = 718;702
triggerall = command = "Shote2"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 1200
trigger1 = command = "Guts Upper"
triggerall = power >= 200
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 1201
trigger1 = command = "Guts Upper1"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

;----------------------------MOVIMENTOS BASICOS --------------------------------

[State -1, ]
type = ChangeState
value = 60
triggerall = !var(59)&&command = "Superpulo"
trigger1 = statetype = S
trigger1 = ctrl

; Carregar Energia 01
[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command="hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)


[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl


[State -1, Run Fwd]
type = ChangeState
value = 101
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl


[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Run Back]
type = ChangeState
value = 115
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl


;---------------------------------------------------------------------------
[State -1, Guard Push stand]
type = ChangeState
value = 160
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = S
trigger1 = stateno = [150,153]

[State -1, Guard Push crouch]
type = ChangeState
value = 161
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = C
trigger1 = stateno = [150,153]

[State -1, Guard Push aerial]
type = ChangeState
value = 162
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = A
trigger1 = stateno = [154,155]



;---------------GOLPES NORMAIS PE ---------------------------------------------




[State -1, Leigan Rapido]
type = ChangeState
value = 311
triggerall = command = "leirap"
triggerall = power >= 250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Leigan Rapido]
type = ChangeState
value = 330
triggerall = command = "leigan"
triggerall = power >= 100
trigger1 = statetype = S
trigger1 = ctrl


[State -1, Leigan Rapido]
type = ChangeState
value = 505
triggerall = command = "lei2"
triggerall = power >= 100
trigger1 = statetype = S
trigger1 = ctrl


[State -1, Leigan Rapido]
type = ChangeState
value = 305
triggerall = command = "counter01"
triggerall = power >= 350
trigger1 = statetype = S
trigger1 = ctrl


[State -1, Leigan Rapido]
type = ChangeState
value = 703
triggerall = command = "counter02"
triggerall = power >= 350
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Leigan Rapido]
type = ChangeState
value = 306
triggerall = command = "empu01"
triggerall = power >= 300
trigger1 = statetype = S
trigger1 = ctrl

[State -1, Leigan Rapido]
type = ChangeState
value = 348
triggerall = command = "hole1"
triggerall = power >= 200
trigger1 = statetype = S
trigger1 = ctrl




;---------------GOLPES NORMAIS NO AR -------------------------------------------

[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  501
trigger1 = command = "leiganalto"
triggerall = power >= 100
trigger1 = statetype = A
trigger1 = ctrl
triggerall = power >= 100

[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  506
trigger1 = command = "leiganalto2"
triggerall = power >= 150
trigger1 = statetype = A
trigger1 = ctrl


[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  1300
trigger1 = command = "chutearyusuke01"
triggerall = power >= 200
trigger1 = statetype = A
trigger1 = ctrl


[State -1, leiganalto]    ; leigan ar original
type = ChangeState
value =  1303
trigger1 = command = "chutearyusuke02"
triggerall = power >= 250
trigger1 = statetype = A
trigger1 = ctrl

;---------------Combos Com Especial------------------------------------------------

[State -1]
type = ChangeState
value = 340
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiga"
triggerall = stateno = 1200
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 723
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiga01"
triggerall = stateno = 348
triggerall = movecontact = 1
trigger1 = statetype = A



;--------------------------------------------------------------------------



[State -1]
type = ChangeState
value = 3025
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "especialfinal"
triggerall = stateno = 308
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 501
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto"
triggerall = stateno = 600
triggerall = movecontact = 1
trigger1 = statetype = A


[State -1]
type = ChangeState
value = 506
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto2"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------


[State -1]
type = ChangeState
value = 501
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto"
triggerall = stateno = 630
triggerall = movecontact = 1
trigger1 = statetype = A


;-------------Combos Marvel Yusuke -------------------------------------------------


[State -1]
type = ChangeState
value = 230
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 202
triggerall = movecontact = 1
trigger1 = statetype = S



;---------------------------------------------------------------------------
[State -1,Varios socos 200]
type             = ChangeState
value            = 200
triggerall       = Command="x"
trigger1         = statetype = S
trigger1         = ctrl
trigger2         = stateno = 301 && movecontact
trigger3         = stateno = 302 && movecontact
trigger4         = stateno = 303 && movecontact


[State -1, varios socos 202]
type             = ChangeState
value            = 1202
triggerall       = Command="x"
trigger1         = statetype = S
trigger1         = ctrl = 1
trigger2         = (stateno = 200) && (Time > 10) && (PrevStateNo != 1202)

[State -1, varios socos 202]
type             = ChangeState
value            = 1202
triggerall       = Command="x"
trigger1         = statetype = S
trigger1         = ctrl = 1
trigger2         = (stateno = 202) && (Time > 10) && (PrevStateNo != 1202)

[State -1, varios socos 202]
type             = ChangeState
value            = 1202
triggerall       = Command="x"
trigger1         = statetype = S
trigger1         = ctrl = 1
trigger2         = (stateno = 203) && (Time > 10) && (PrevStateNo != 1202)


[State -1, varios socos 202]
type             = ChangeState
value            = 203
triggerall       = Command="x"
trigger1         = statetype = S
trigger1         = ctrl = 1
trigger2         = (stateno = 211) && (Time > 5) && (PrevStateNo != 203)


;---------------------------------------------------------------------------

 [State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------

  [State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S



;---------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;--------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 211
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 60
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "Superpulo"
triggerall = stateno = 410
triggerall = movecontact = 1
trigger1 = statetype = S


;---------------------------------------------------------------------------

 [State -1]
type = ChangeState
value = 213
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S



;---------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 232
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 202
triggerall = movecontact = 1
trigger1 = statetype = S

;--------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 230
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 211
triggerall = movecontact = 1
trigger1 = statetype = S


;--------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 501
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = S



;---------------------------------------------------------------------------
 ;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

;---------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S



;--------------------------------------------------------------------------

 [State -1]
type = ChangeState
value = 232
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6




;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Soco fracp aga original
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

[State -1]
type = ChangeState
value = 304
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "hole1"
triggerall = stateno = 400
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 430
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 400
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 304
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "hole1"
triggerall = stateno = 430
triggerall = movecontact = 1
trigger1 = statetype = A


;--------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 400
triggerall = movecontact = 1
trigger1 = statetype = A



;---------------------------------------------------------------------------


[State -1]
type = ChangeState
value = 440
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 400
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Soco aga forte original
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl



;---------------------------------------------------------------------------


[State -1]
type = ChangeState
value = 440
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 410
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------


[State -1]
type = ChangeState
value = 400
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 410
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;chute aga fraco original
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl



;----------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 400
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 430
triggerall = movecontact = 1
trigger1 = statetype = C

;----------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 430
triggerall = movecontact = 1
trigger1 = statetype = A

;----------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 430
triggerall = movecontact = 1
trigger1 = statetype = C

;---------------------------------------------------------------------------


[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 430
triggerall = movecontact = 1
trigger1 = statetype = C



;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 400
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 430
triggerall = movecontact = 1
trigger1 = statetype = A

;-----------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 430
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;soco ar fraco original
;󒆎p`
[State -1, varios socos 202]
type             = ChangeState
value            = 600
triggerall       = Command="x"
trigger1         = statetype = A
trigger1         = ctrl
trigger2         = stateno = 301 && movecontact
trigger3         = stateno = 302 && movecontact
trigger4         = stateno = 303 && movecontact

[State -1, varios socos 202]
type             = ChangeState
value            = 600
triggerall       = Command="z"
trigger1         = statetype = A
trigger1         = ctrl
trigger2         = stateno = 301 && movecontact
trigger3         = stateno = 302 && movecontact
trigger4         = stateno = 303 && movecontact


[State -1, varios socos 202]
type             = ChangeState
value            = 601
triggerall       = Command="x"
trigger1         = statetype = A
trigger1         = ctrl
trigger2         = (stateno = 600) && (Time > 5) && (PrevStateNo != 601)

;---------------------------------------------------------------------------
[State -1]
type = ChangeState
value = 630
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 600
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Soco ar forte original
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact



[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 601
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

;-------------------------------------------------------------------------

[State -1]   ;chute ar forte original
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

;--------------------------------------------------------------------------

 [State -1]
type = ChangeState
value = 630
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A



;--------------------------------------------------------------------------

 [State -1]     ; chute ar fraco original
type = ChangeState
value = 630
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A


;-------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 600
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 630
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 601
triggerall = movecontact = 1
trigger1 = statetype = A



;--------------------------------------------------------------------------


 [State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 630
triggerall = movecontact = 1
trigger1 = statetype = A

;--------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 610
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A


;--------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 501
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A
;---------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 501
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "leiganalto"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact


